Attribute VB_Name = "Module1"
Option Explicit

Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public SetupLAN As Integer
Public StopVecCorrFlag As Boolean
'---------Power On Recall Data -----10/Oct/2012--------------
Public TableAutoFlag As Boolean
Public AutoFreq1Flag As Integer
Public AutoFreq3Flag As Integer
Public AutoFreq6Flag As Integer
Public AutoFreq8Flag As Integer
Public ManualCF As String
Public ManualName As String
Public FileHeaderFlag As Integer
Public FileHeaderName As String
Public GetInbandFlag As Boolean
Public IPaddress As String
Public OffsetFreqDsp As Integer



Public Function Direct_CAL_End(PollingInterval As Long, TimeOut As Long) As Integer
    '--------------- Direct Cal End Check -----------
    'Return val
    '0 = OK
    '1 = not used
    '2 = Time Out
    Dim ReadBuffer As String * 10
    Dim OPRevt As Integer
    Dim STtimer As Double

    STtimer = Timer
    Direct_CAL_End = 0
    Do
        DoEvents
        Sleep PollingInterval
        SendDtFunc ("OPREVT?")
        ReadBuffer = RcvDtFunc
        OPRevt = Val(ReadBuffer)
        Debug.Print "SPA OPREVT: " & OPRevt
        If Timer > (STtimer + TimeOut) Then
            Direct_CAL_End = 2
            Exit Function
        End If
    Loop While ((OPRevt And 1) = 0)

End Function
Public Function SendDtFunc(dt As String) As Integer
    Dim ipErr As Long

    SendDtFunc = 0
    On Error GoTo ErrOcc
    ipErr = 0
    
    'Send data+LF to Instrument
    Form1.tcpClient.SendData dt + vbLf
    DoEvents
    If ipErr <> 0 Then
        SendDtFunc = 1
        Exit Function
    End If
    Exit Function

ErrOcc:
    ipErr = Err.Number
    Resume Next

End Function
Public Function RcvDtFunc() As String
    Dim RcvDt As String

    Do While (Form1.tcpClient.BytesReceived = 0)
        DoEvents
    Loop
    
    Form1.tcpClient.GetData RcvDt
    RcvDtFunc = RcvDt
End Function

Public Sub SetTable(StartIndex As Integer, StartCF As Double, StepNum As Integer, StartFileFooter As Integer)
    Dim lRow As Integer
    Dim CFData As Double
    
    With Form1.CFTable
        For lRow = StartIndex To StartIndex + StepNum - 1
            .TextMatrix(lRow, 0) = Format(StartCF / 1000000, "####0")
            .TextMatrix(lRow, 1) = "VecCorr" + Format(StartFileFooter, "0000") + "M"
            
            StartCF = StartCF + 40000000#
            StartFileFooter = StartFileFooter + 40
        Next lRow
    End With
End Sub


'Save Initial data
'---------------------------------------------------------------------------------------------------------

Public Sub InitSave()

Dim InitFileDir As String

On Error GoTo ErrProcSave

    '----------------- Copy Data -----------------------
    TableAutoFlag = Form1.CFAuto.Value
    AutoFreq1Flag = Form1.chkRange1G.Value
    AutoFreq3Flag = Form1.chkRange3G.Value
    AutoFreq6Flag = Form1.chkRange6G.Value
    AutoFreq8Flag = Form1.chkRange8G.Value
    ManualCF = Form1.txtCF.Text
    ManualName = Form1.txtFileName.Text
    FileHeaderFlag = Form1.chkHeader.Value
    FileHeaderName = Form1.txtFileHeader.Text
    GetInbandFlag = Form1.Get_Inband_Corr.Value
    IPaddress = Form1.txtIPAddress.Text
    '----------------------------------------------------
    
    InitFileDir = App.Path + "\VecCorrInit.dat"
    
    Open InitFileDir For Output As #1
    
        '------- Save Data -----
        Write #1, TableAutoFlag; AutoFreq1Flag; AutoFreq3Flag; AutoFreq6Flag; AutoFreq8Flag; ManualCF
        Write #1, ManualName; FileHeaderFlag; FileHeaderName; GetInbandFlag; OffsetFreqDsp; IPaddress
    
    Close #1
        
    Exit Sub                                                    'EXIT------------
    
ErrProcSave:                                                    'ERROR (The File is not saved.)
    Close #1
    
End Sub


'Recall Initial data
'---------------------------------------------------------------------------------------------------------
Public Sub InitRecall()

Dim InitFileDir As String

On Error GoTo ErrProcRecall

    InitFileDir = App.Path + "\VecCorrInit.dat"

    Open InitFileDir For Input As #1

        Input #1, TableAutoFlag, AutoFreq1Flag, AutoFreq3Flag, AutoFreq6Flag, AutoFreq8Flag, ManualCF
        Input #1, ManualName, FileHeaderFlag, FileHeaderName, GetInbandFlag, OffsetFreqDsp, IPaddress

    Close #1

    '--------------------- Recall OK ----------------------------

    Exit Sub                                                    'EXIT-----------------


ErrProcRecall:                                                  'Error--> Initial set...

    Close #1

    '----------------- Initial Data -----------------------
    TableAutoFlag = True
    AutoFreq1Flag = 1
    AutoFreq3Flag = 0
    AutoFreq6Flag = 0
    AutoFreq8Flag = 0
    OffsetFreqDsp = 0
    ManualCF = "300"
    ManualName = "VecCorr0300M"
    FileHeaderFlag = False
    FileHeaderName = "PreAmp"
    GetInbandFlag = True
    IPaddress = "192.168.0.1"
    '----------------------------------------------------

    '----------------- End of Initial Data setup ----------------------
    
End Sub
